//=============================================================================
// TeamGamePlus.
//=============================================================================
class DanesRPGgame extends TeamGamePlus config(DanesRPGgame);

var()		 bool   bSpawnInTeamArea;
var()		 bool	bScoreTeamKills;
var() config bool	bNoTeamChanges;
var			 int	NumSupportingPlayer; 
var globalconfig	 bool	bBalanceTeams;	// bots balance teams
var globalconfig	 bool	bPlayersBalanceTeams;	// players balance teams
var			 bool	bBalancing;
var() config float  FriendlyFireScale; //scale friendly fire damage by this value
var() config int	MaxTeams; //Maximum number of teams allowed in (up to MaxAllowedTeams)
var			 int	MaxAllowedTeams;
var	TeamInfo Teams[4]; // Red, Blue, Green, Gold
var() config float  GoalTeamScore; //like fraglimit
var() config int	MaxTeamSize;
var  localized string StartUpTeamMessage, TeamChangeMessage,TeamPrefix;
var localized string TeamColor[4];

var		int			NextBotTeam;
var byte TEAM_Red, TEAM_Blue, TEAM_Green, TEAM_Gold;
var name CurrentOrders[4];
var int PlayerTeamNum;
var localized string StartupTeamTralier;

var bool bTheEnd; //set when game has ended
var int delay; // time in seconds to move after last enemy is killed

//Database Player Variables:
var config string 		Players[10000];			//stores the players name
var config int			Score[10000];			//stores the players total score
var config int			Level[10000];			//stores the players current level
var config string		Weapons[10000];			//stores each weapon and armor the player has, reset at death
var config int			RegainHealth[10000];		//skill, defines how fast a players health is regaining
var config int			RegainAmmo[10000];		//skill, defines how fast a players ammo is regaining
var config int			RReduceDamage[10000];		//skill, defines how much a players damage taken is reduced
var config int			AddToDamage[10000];		//skill, defines how much damage to add to players damage done
var config int			AddFireDamage[10000];		//skill, defines how much fire damage to add to damage done
var config int			AddLightningDamage[10000];	//skill, defines how much lightning damage to add to damage done
var config int			AddPoisonDamage[10000];		//skill, defines how much poison damage to add to damage done
var config int			AddColdDamage[10000];		//skill, defines how much cold damage to add to damage done
var config int			LastVisit[10000];		//defines the number of days since the player was last on the server
var config int			CurrentDay;			//Holds the current day of the server, to trigger the new day funtion that adds a day to each player in the database

//temp Player Variables:
var string 			TPlayers[16];			//stores the players name
var int				TScore[16];			//stores the players total score
var int				TLevel[16];			//stores the players current level
var string			TWeapons[16];			//stores each weapon and armor the player has, reset at death
var int				TRegainHealth[16];		//skill, defines how fast a players health is regaining
var int				TRegainAmmo[16];		//skill, defines how fast a players ammo is regaining
var int				TReduceDamage[16];		//skill, defines how much a players damage taken is reduced
var int				TAddToDamage[16];		//skill, defines how much damage to add to players damage done
var int				TAddFireDamage[16];		//skill, defines how much fire damage to add to damage done
var int				TAddLightningDamage[16];	//skill, defines how much lightning damage to add to damage done
var int				TAddPoisonDamage[16];		//skill, defines how much poison damage to add to damage done
var int				TAddColdDamage[16];		//skill, defines how much cold damage to add to damage done
var int				TLastVisit[16];			//defines the number of days since the player was last on the server

var bool Init,Init2;

var string PlayersAccessedDB[128];
var int TimerEvent;




//This function transfers the temp stats to the replication info class, triggered from function Timer.
function TransferTempToGRI()
{
local rpg_GRI TGRI;
local PlayerPawn P;
local bool bHasBeenTransfered;

	bHasBeenTransfered = False;

	foreach AllActors(class'PlayerPawn', P)
		{
		if (!bHasBeenTransfered)
			{
			//Transfer Player #0 stats
			if ( TPlayers[0] != "")
				{
				TGRI.TPlayers0 = TPlayers[0];
				TGRI.TLevel0 = TLevel[0];
				TGRI.TRegainHealth0 = TRegainHealth[0];
				TGRI.TRegainAmmo0 = TRegainAmmo[0];
				TGRI.TReduceDamage0 = RReduceDamage[0];
				TGRI.TAddToDamage0 = TAddToDamage[0];
				TGRI.TAddFireDamage0 = TAddFireDamage[0];
				TGRI.TAddLightningDamage0 = TAddLightningDamage[0];
				TGRI.TAddPoisonDamage0 = TAddPoisonDamage[0];
				TGRI.TAddColdDamage0 = TAddColdDamage[0];
				TGRI.TLastVisit0 = TLastVisit[0];
				TPlayers[0] = "";
				}
			bHasBeenTransfered = True;
			}
	
		}
}

//This function handles the transfers of stats to the player joining the game (or when new map starts), triggered from function Timer.
function AccessDB()
{
local PlayerPawn P;
local int i,ii,iii;

	foreach AllActors(class'PlayerPawn', P)
		{
		for (i=0;i<128;i++)
			{
			if (P.PlayerReplicationInfo.PlayerName == PlayersAccessedDB[i])
				{
				i=256;
				return;
				}
			else if (PlayersAccessedDB[i] == "")
				{
				for (ii=0;ii<10000;ii++)
					{
					if ( P.PlayerReplicationInfo.PlayerName == Players[ii] || Players[ii] == "")
						{
						Players[ii] = P.PlayerReplicationInfo.PlayerName;
						P.PlayerReplicationInfo.Score = Score[ii];
						for (iii=0;iii<16;iii++)
							{
							if (P.PlayerReplicationInfo.PlayerName == TPlayers[iii] || TPlayers[iii] == "")
								{
								TPlayers[iii] = Players[ii];
								TLevel[iii] = Level[ii];
								TWeapons[iii] = Weapons[ii];
								TRegainHealth[iii] = RegainHealth[ii];
								TRegainAmmo[iii] = RegainAmmo[ii];
								TReduceDamage[iii] = RReduceDamage[ii];
								TAddToDamage[iii] = AddToDamage[ii];
								TAddFireDamage[iii] = AddFireDamage[ii];
								TAddLightningDamage[iii] = AddLightningDamage[ii];
								TAddPoisonDamage[iii] = AddPoisonDamage[ii];
								TAddColdDamage[iii] = AddColdDamage[ii];
								TLastVisit[iii] = LastVisit[ii];
								iii = 50;
								PlayersAccessedDB[i] = P.PlayerReplicationInfo.PlayerName;
								i = 256;
								//log("Player accessed DB");
								//log("Name: "@Players[ii]);
								//log("Score: "@Score[ii]);
								}
							}
						ii = 20000;
						}
					}
				}
			}
		}
}

function AddDefaultInventory( pawn PlayerPawn )
{
	local Weapon NewWeapon;
	local Bot B;

	if ( PlayerPawn.IsA('Spectator') || (bRequireReady && (CountDown > 0)) )
		return;

	// Spawn Lawgiver to PlayerPawns
	GiveWeapon(PlayerPawn, "BotPack.ImpactHammer");
	GiveWeapon(PlayerPawn, "DanesRPGgame.Weapon_Enforcer");
	GiveWeapon(PlayerPawn, "DanesRPGgame.Weapon_SniperRifle");


	if ( bUseTranslocator && (!bRatedGame || bRatedTranslocator) )
	{
		// Spawn Translocator.
		if( PlayerPawn.FindInventoryType(class'Translocator')==None )
		{
			newWeapon = Spawn(class'Translocator');
			if( newWeapon != None )
			{
				newWeapon.Instigator = PlayerPawn;
				newWeapon.BecomeItem();
				PlayerPawn.AddInventory(newWeapon);
				newWeapon.GiveAmmo(PlayerPawn);
				newWeapon.SetSwitchPriority(PlayerPawn);
				newWeapon.WeaponSet(PlayerPawn);
			}
		}
	}

	B = Bot(PlayerPawn);
	if ( B != None )
		B.bHasImpactHammer = (B.FindInventoryType(class'ImpactHammer') != None);
}	

function PostBeginPlay()
{
	local int i;
	local Pawn P;

	for (i=0;i<4;i++)
	{
		Teams[i] = Spawn(class'TeamInfo');
		Teams[i].Size = 0;
		Teams[i].Score = 0;
		Teams[i].TeamName = TeamColor[i];
		Teams[i].TeamIndex = i;
		TournamentGameReplicationInfo(GameReplicationInfo).Teams[i] = Teams[i];
	}
	
	Super.PostBeginPlay();

	SetTimer(0.5, true);

	if ( bRatedGame )
	{
		FriendlyFireScale = 0;
		MaxTeams = 2;
	}

	
}

event InitGame( string Options, out string Error )
{
	Super.InitGame(Options, Error);
	MaxTeams = Min(MaxTeams,MaxAllowedTeams);
}

function InitGameReplicationInfo()
{
	Super.InitGameReplicationInfo();

	TournamentGameReplicationInfo(GameReplicationInfo).GoalTeamScore = GoalTeamScore;
}

// Set game settings based on ladder information.
// Called when RatedPlayer logs in.
function InitRatedGame(LadderInventory LadderObj, PlayerPawn LadderPlayer)
{
	local class<RatedMatchInfo> RMI;
	local Weapon W;

	GoalTeamScore = LadderObj.CurrentLadder.Default.GoalTeamScore[IDnum];
	Super.InitRatedGame(LadderObj, LadderPlayer);	
	bCoopWeaponMode = true;
	FriendlyFireScale = 0.0;
	MaxTeams = 2;
	ForEach AllActors(class'Weapon', W)
		W.SetWeaponStay();
}

function CheckReady()
{
	if ( (TimeLimit == 0) && (GoalTeamScore == 0) )
	{
		TimeLimit = 20;
		RemainingTime = 60 * TimeLimit;
	}
}

event PostLogin( playerpawn NewPlayer )
{
	Super.PostLogin(NewPlayer);

//	if ( Level.NetMode != NM_Standalone )
//		NewPlayer.ClientChangeTeam(NewPlayer.PlayerReplicationInfo.Team);


	NewPlayer.ClientChangeTeam(0); // Force every PlayerPawn joining to team 0 (Red)

}

function LogGameParameters(StatLog StatLog)
{
	if (StatLog == None)
		return;
	
	Super.LogGameParameters(StatLog);

	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"GoalTeamScore"$Chr(9)$int(GoalTeamScore));
	StatLog.LogEventString(StatLog.GetTimeStamp()$Chr(9)$"game"$Chr(9)$"FriendlyFireScale"$Chr(9)$FriendlyFireScale);
}

function bool SetEndCams(string Reason)
{
	local TeamInfo BestTeam;
	local int i;
	local pawn P, Best;
	local PlayerPawn player;

	Super.SetEndCams(Reason);
/*

	// find individual winner
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
		if ( P.bIsPlayer && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
			Best = P;

	// find winner
	BestTeam = Teams[0];
	for ( i=1; i<MaxTeams; i++ )
		if ( Teams[i].Score > BestTeam.Score )
			BestTeam = Teams[i];

	for ( i=0; i<MaxTeams; i++ )
		if ( (BestTeam.TeamIndex != i) && (BestTeam.Score == Teams[i].Score) )
		{
			BroadcastLocalizedMessage( DMMessageClass, 0 );
			return false;
		}		

	GameReplicationInfo.GameEndedComments = TeamPrefix@BestTeam.TeamName@GameEndedMessage;

	EndTime = Level.TimeSeconds + 3.0;
	for ( P=Level.PawnList; P!=None; P=P.nextPawn )
	{
		player = PlayerPawn(P);
		if ( Player != None )
		{
			if (!bTutorialGame)
				PlayWinMessage(Player, (Player.PlayerReplicationInfo.Team == BestTeam.TeamIndex));
			player.bBehindView = true;
			if ( Player == Best )
				Player.ViewTarget = None;
			else
				Player.ViewTarget = Best;
			player.ClientGameEnded();
		}
		P.GotoState('GameEnded');
	}
*/

	CalcEndStats();
	return true;
}

//------------------------------------------------------------------------------
// Player start functions

/*
function PlayStartUpMessage(PlayerPawn NewPlayer)
{
	local int i;
	local color WhiteColor;

	NewPlayer.ClearProgressMessages();

	// GameName
	NewPlayer.SetProgressMessage(GameName, i++);
	if ( bRequireReady && (Level.NetMode != NM_Standalone) )
		NewPlayer.SetProgressMessage(TourneyMessage, i++);
	else
		NewPlayer.SetProgressMessage(StartUpMessage, i++);

	if ( GoalTeamScore > 0 )
		NewPlayer.SetProgressMessage(int(GoalTeamScore)@GameGoal, i++);

	if ( NewPlayer.PlayerReplicationInfo.Team < 4 )
	{
		NewPlayer.SetProgressColor(class'ChallengeTeamHUD'.Default.TeamColor[NewPlayer.PlayerReplicationInfo.Team], i);
		NewPlayer.SetProgressMessage(StartupTeamMessage@Teams[NewPlayer.PlayerReplicationInfo.Team].TeamName$StartupTeamTralier, i++);
		WhiteColor.R = 255;
		WhiteColor.G = 255;
		WhiteColor.B = 255;
		NewPlayer.SetProgressColor(WhiteColor, i);
		if ( !bRatedGame )
			NewPlayer.SetProgressMessage(TeamChangeMessage, i++);
	}

	if ( Level.NetMode == NM_Standalone )
		NewPlayer.SetProgressMessage(SingleWaitingMessage, i++);
}
*/

function playerpawn Login
(
	string Portal,
	string Options,
	out string Error,
	class<playerpawn> SpawnClass
)
{
	local PlayerPawn newPlayer;
	local NavigationPoint StartSpot;

	newPlayer = Super.Login(Portal, Options, Error, SpawnClass);
	if ( newPlayer == None)
		return None;

	if ( bSpawnInTeamArea )
	{
		StartSpot = FindPlayerStart(NewPlayer,255, Portal);
		if ( StartSpot != None )
		{
			NewPlayer.SetLocation(StartSpot.Location);
			NewPlayer.SetRotation(StartSpot.Rotation);
			NewPlayer.ViewRotation = StartSpot.Rotation;
			NewPlayer.ClientSetRotation(NewPlayer.Rotation);
			StartSpot.PlayTeleportEffect( NewPlayer, true );
		}
	}
//	PlayerTeamNum = NewPlayer.PlayerReplicationInfo.Team;

	PlayerTeamNum = 0; // Force every PlayerPawn into team 0 (Red)
		
	return newPlayer;
}

function Logout(pawn Exiting)
{
	Super.Logout(Exiting);
	if ( Exiting.IsA('Spectator') || Exiting.IsA('Commander') )
		return;
    Teams[Exiting.PlayerReplicationInfo.Team].Size--;
	ClearOrders(Exiting);
	if ( !bGameEnded && bBalanceTeams && !bRatedGame )
		ReBalance();
}

// Find a team given its name
function byte FindTeamByName( string TeamName )
{
	local byte i;

	for ( i=0; i<MaxTeams; i++ )
		if ( Teams[i].TeamName == TeamName )
			return i;

	return 255; // No Team
}

// rebalance teams after player changes teams or leaves
// find biggest and smallest teams.  If 2 apart, move bot from biggest to smallest

/*
function ReBalance()
{
	local int big, small, i, bigsize, smallsize;
	local Pawn P, A;
	local Bot B;

	if ( bBalancing || (NumBots == 0) )
		return;

	big = 0;
	small = 0;
	bigsize = Teams[0].Size;
	smallsize = Teams[0].Size;
	for ( i=1; i<MaxTeams; i++ )
	{
		if ( Teams[i].Size > bigsize )
		{
			big = i;
			bigsize = Teams[i].Size;
		}
		else if ( Teams[i].Size < smallsize )
		{
			small = i;
			smallsize = Teams[i].Size;
		}
	}
	
	bBalancing = true;
	while ( bigsize - smallsize > 1 )
	{
		for ( P=Level.PawnList; P!=None; P=P.NextPawn )
			if ( P.bIsPlayer && (P.PlayerReplicationInfo.Team == big)
				&& P.IsA('Bot') )
			{
				B = Bot(P);
				break;
			}
		if ( B != None )
		{
			B.Health = 0;
			B.Died( None, 'Suicided', B.Location );
			bigsize--;
			smallsize++;
			ChangeTeam(B, small);
		}
		else
			Break;
	}
	bBalancing = false;

	// re-assign orders to follower bots with no leaders
	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.bIsPlayer && P.IsA('Bot') && (BotReplicationInfo(P.PlayerReplicationInfo).RealOrders == 'Follow') )
		{
			A = Pawn(Bot(P).OrderObject);
			if ( (A == None) || A.bDeleteMe || !A.bIsPlayer || (A.PlayerReplicationInfo.Team != P.PlayerReplicationInfo.Team) )
			{
				Bot(P).OrderObject = None;
				SetBotOrders(Bot(P));
			}
		}

}
*/
/*	
function NavigationPoint FindPlayerStart( Pawn Player, optional byte InTeam, optional string incomingName )
{
	local PlayerStart Dest, Candidate[16], Best;
	local float Score[16], BestScore, NextDist;
	local pawn OtherPlayer;
	local int i, num;
	local Teleporter Tel;
	local NavigationPoint N;
	local byte Team;

	if ( Player.IsA('PlayerPawn') )
		{
		return TournamentPlayer(Player).StartSpot;
		}

	if (Player.IsA('Bot'))
		{
		Player.Destroy();
		}

	if ( (Player != None) && (Player.PlayerReplicationInfo != None) )
		//Team = Player.PlayerReplicationInfo.Team;
		Team = 0;
	else
		Team = 0;

	if( incomingName!="" )
		foreach AllActors( class 'Teleporter', Tel )
			if( string(Tel.Tag)~=incomingName )
				return Tel;

	if ( Team == 255 )
		Team = 0;
				
	//choose candidates	
	for ( N=Level.NavigationPointList; N!=None; N=N.nextNavigationPoint )
	{
		Dest = PlayerStart(N);
		if ( (Dest != None) && Dest.bEnabled
			&& (!bSpawnInTeamArea || (Team == Dest.TeamNumber)) )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
	}

	if (num == 0 )
	{
		log("Didn't find any player starts in list for team"@Team@"!!!"); 
		foreach AllActors( class'PlayerStart', Dest )
		{
			if (num<16)
				Candidate[num] = Dest;
			else if (Rand(num) < 16)
				Candidate[Rand(16)] = Dest;
			num++;
		}
		if ( num == 0 )
			return None;
	}

	if (num>16) 
		num = 16;
	
	//assess candidates
	for (i=0;i<num;i++)
	{
		if ( Candidate[i] == LastStartSpot )
			Score[i] = -6000.0;
		else
			Score[i] = 4000 * FRand(); //randomize
	}		
	
	for ( OtherPlayer=Level.PawnList; OtherPlayer!=None; OtherPlayer=OtherPlayer.NextPawn)	
		if ( OtherPlayer.bIsPlayer && (OtherPlayer.Health > 0) && !OtherPlayer.IsA('Spectator') )
			for (i=0; i<num; i++)
				if ( OtherPlayer.Region.Zone == Candidate[i].Region.Zone ) 
				{
					Score[i] -= 1500;
					NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
					if (NextDist < 2 * (CollisionRadius + CollisionHeight))
						Score[i] -= 1000000.0;
					else if ( (NextDist < 2000) && (OtherPlayer.PlayerReplicationInfo.Team != Team)
							&& FastTrace(Candidate[i].Location, OtherPlayer.Location) )
						Score[i] -= (10000.0 - NextDist);
				}
	
	BestScore = Score[0];
	Best = Candidate[0];
	for (i=1; i<num; i++)
		if (Score[i] > BestScore)
		{
			BestScore = Score[i];
			Best = Candidate[i];
		}
	LastStartSpot = Best;
				
	return Best;


}
*/

//-------------------------------------------------------------------------------------
// Level gameplay modification

//Use reduce damage for teamplay modifications, etc.
function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
	Damage = Super.ReduceDamage(Damage, DamageType, injured, instigatedBy);
	
	if ( instigatedBy == None )
		return Damage;

	if ( (instigatedBy != injured) && injured.bIsPlayer && instigatedBy.bIsPlayer 
		&& (injured.PlayerReplicationInfo.Team == instigatedBy.PlayerReplicationInfo.Team) )
	{
		if ( injured.IsA('Bot') )
			Bot(Injured).YellAt(instigatedBy);
		return (Damage * FriendlyFireScale);
	}
	else
		return Damage;
}

function SpawnHealthPickup(Pawn Other, int Chance)
{
local int R;

	R = Rand(100);

	if ( R <= Chance )
		{
		R = Rand(19);
		
		if ( R < 5 )
			{
			spawn(class'Health_HealthVial',Other,,Other.Location+vect(0,0,-20));
			}
		else if ( R < 8 )
			{
			spawn(class'Health_MedBox',Other,,Other.Location+vect(0,0,-20));
			}
		else if ( R < 16 )
			{
			spawn(class'Health_Bandages',Other,,Other.Location+vect(0,0,-20));
			}
		else if ( R < 17 )
			{
			spawn(class'Health_HealthPack',Other,,Other.Location+vect(0,0,-20));
			}
		else
			{
			spawn(class'Health_SuperHealth',Other,,Other.Location+vect(0,0,-20));
			}
		}
}

function SpawnAmmoPickup(Pawn Other, int Chance)
{
local int R;

	R = Rand(100);

	if ( R <= Chance )
		{
		R = Rand(47);
		
		if ( R < 5 )
			{
			spawn(class'BotPack.BladeHopper',Other,,Other.Location+vect(10,20,-20));
			}
		else if ( R < 10 )
			{
			spawn(class'BotPack.BioAmmo',Other,,Other.Location+vect(10,20,-20));
			}
		else if ( R < 15 )
			{
			spawn(class'BotPack.BulletBox',Other,,Other.Location+vect(10,20,-20));
			}
		else if ( R < 20 )
			{
			spawn(class'DanesRPGgame.Ammo_EClip',Other,,Other.Location+vect(10,20,-20));
			}
		else if ( R < 25 )
			{
			spawn(class'BotPack.FlakAmmo',Other,,Other.Location+vect(10,20,-20));
			}
		else if ( R < 30 )
			{
			spawn(class'BotPack.MiniAmmo',Other,,Other.Location+vect(10,20,-20));
			}
		else if ( R < 35 )
			{
			spawn(class'BotPack.PAmmo',Other,,Other.Location+vect(10,20,-20));
			}
		else if ( R < 40 )
			{
			spawn(class'BotPack.RocketPack',Other,,Other.Location+vect(10,20,-20));
			}
		else if ( R < 45 )
			{
			spawn(class'BotPack.ShockCore',Other,,Other.Location+vect(10,20,-20));
			}
		else
			{
			spawn(class'BotPack.WarHeadAmmo',Other,,Other.Location+vect(10,20,-20));
			}
		}
}

function SpawnArmorPickup(Pawn Other, int Chance)
{
local int R;

	R = Rand(100);

	if ( R <= Chance )
		{
		R = Rand(9);
		
		if ( R < 2 )
			{
			spawn(class'BotPack.Armor2',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 3 )
			{
			spawn(class'BotPack.UT_ShieldBelt',Other,,Other.Location+vect(0,0,-20));
			}
		else if ( R < 7 )
			{
			spawn(class'BotPack.ThighPads',Other,,Other.Location+vect(0,0,-20));
			}
		else
			{
			spawn(class'UnrealShare.KevlarSuit',Other,,Other.Location+vect(0,0,-5));
			}
		}
}

function SpawnWeaponPickup(Pawn Other, int Chance)
{
local int R;

	R = Rand(100);

	if ( R <= Chance )
		{
		R = Rand(25);
		
		if ( R < 2 )
			{
			spawn(class'BotPack.ChainSaw',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 7 )
			{
			spawn(class'DanesRPGgame.Weapon_Enforcer',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 9 )
			{
			spawn(class'BotPack.minigun2',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 12 )
			{
			spawn(class'BotPack.PulseGun',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 14 )
			{
			spawn(class'BotPack.Ripper',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 16 )
			{
			spawn(class'BotPack.ShockRifle',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 19 )
			{
			spawn(class'DanesRPGgame.Weapon_SniperRifle',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 22 )
			{
			spawn(class'BotPack.ut_biorifle',Other,,Other.Location+vect(0,0,-10));
			}
		else if ( R < 24 )
			{
			spawn(class'BotPack.UT_Eightball',Other,,Other.Location+vect(0,0,-10));
			}
		else
			{
			spawn(class'BotPack.WarHeadLauncher',Other,,Other.Location+vect(0,0,-10));
			}
		}
}

function SpawnMiscPickup(Pawn Other, int Chance)
{
local int R;

	R = Rand(100);

	if ( R <= Chance )
		{
		R = Rand(8);
		
		if ( R < 2 )
			{
			spawn(class'BotPack.UDamage',Other,,Other.Location+vect(0,0,-20));
			}
		else if ( R < 4 )
			{
			spawn(class'BotPack.UT_invisibility',Other,,Other.Location+vect(0,0,-20));
			}
		else
			{
			spawn(class'BotPack.UT_Jumpboots',Other,,Other.Location+vect(0,0,-20));
			}
		}
}


function ScoreKill(pawn Killer, pawn Other)
{
local int R;
local bool bGiveSpecialWeapon;	//set to true to spawn special weapon

	if ( (Killer == None) || (Killer == Other) || !Other.bIsPlayer || !Killer.bIsPlayer 
		|| (Killer.PlayerReplicationInfo.Team != Other.PlayerReplicationInfo.Team) )
		Super.ScoreKill(Killer, Other);

	
	if (Other.IsA('Bot'))
		{
		//To spawn item call to e.g. SpawnHealthPickup(Other, 100), this will spawn item, at Others location with a chance of 100% success
		//SpawnHealthPickup(Other, 100);
		//SpawnAmmoPickup(Other, 100);
		//SpawnArmorPickup(Other, 100);
		//SpawnWeaponPickup(Other, 100);
		//SpawnMiscPickup(Other, 100);

		//Assign what item to spawn and what chance for succesfull spawn:

		//Check if Bot is a TBoss model
			if (Other.IsA('TBossBot'))
				{
				if (Other.Tag == 'WaterXan')
					{
					SpawnWeaponPickup(Other, 100);
					}
				else
					{
					SpawnAmmoPickup(Other, 75);
					}
				}

			//Check if Bot is a TMale2Bot
			else if (Other.IsA('TMale2Bot'))
				{
				if (Other.Tag == 'Soldier')
					{
					SpawnHealthPickup(Other, 75);
					SpawnAmmoPickup(Other, 75);
					}
				else
					{
					SpawnHealthPickup(Other, 50);
					SpawnAmmoPickup(Other, 25);
					}
				}

			//Check if Bot is a SkaarjBot
			else if (Other.IsA('SkaarjBot'))
				{
				if (Other.Tag == 'Commander')
					{
					SpawnWeaponPickup(Other, 100);
					}
				else
					{
					SpawnWeaponPickup(Other, 50);
					}
				}

			//Check if Bot is a eightleggedfreaks model (spider)
			else if (Other.IsA('jumperbot'))
				{
				if (Other.Tag == 'Spider')
					{
					SpawnArmorPickup(Other, 75);
					}
				else
					{
					SpawnArmorPickup(Other, 50);
					}
				}

			else if (Other.IsA('spitterbot'))
				{
				if (Other.Tag == 'Spitter')
					{
					SpawnArmorPickup(Other, 50);
					}
				if (Other.Tag == 'Cruella')
					{
					SpawnHealthPickup(Other, 100);
					SpawnMiscPickup(Other, 100);
					}
				else
					{
					SpawnHealthPickup(Other, 60);
					}
				}

			else if (Other.IsA('tarantulabot'))
				{
				if (Other.Tag == 'VenomSpider')
					{
					SpawnHealthPickup(Other, 75);
					}
				else if (Other.Tag == 'Tarantula')
					{
					SpawnWeaponPickup(Other, 10);
					}
				else if (Other.Tag == 'YoungAracnids')
					{
					SpawnHealthPickup(Other, 25);
					}
				else
					{
					SpawnHealthPickup(Other, 50);
					}
				}
			else
				{
				R = Rand(100);
				if (R < 50)
					{
					SpawnHealthPickup(Other, 35);
					}
				else if (R < 60)
					{
					SpawnWeaponPickup(Other, 35);
					}
				else if (R < 80)
					{
					SpawnArmorPickup(Other, 35);
					}
				else if (R < 90)
					{
					SpawnMiscPickup(Other, 35);
					}
				else
					{
					SpawnAmmoPickup(Other, 75);
					}
				}
		}
}

function Killed(pawn killer, pawn Other, name damageType)
{
	local int NextTaunt, i;
	local bool bAutoTaunt, bEndOverTime;
	local Pawn P, Best;

	if ( (damageType == 'Decapitated') && (Killer != Other) && (Killer != None) )
	{
		Killer.ReceiveLocalizedMessage( class'DecapitationMessage' );
	}

	Super.Killed(killer, Other, damageType);

	if ( Other.Spree > 4 )
		EndSpree(Killer, Other); 
	Other.Spree = 0;
	
	if ( (killer == None) || (Other == None) )
		return;
	if ( !bFirstBlood )
		if ( Killer.bIsPlayer && (Killer != Other) )
			if (!Self.IsA('TrainingDM'))
			{
				bFirstBlood = True;
				BroadcastLocalizedMessage( class'FirstBloodMessage', 0, Killer.PlayerReplicationInfo );
			}

	if ( BotConfig.bAdjustSkill && (killer.IsA('PlayerPawn') || Other.IsA('PlayerPawn')) )
	{
		if ( killer.IsA('Bot') )
			BotConfig.AdjustSkill(Bot(killer),true);
		if ( Other.IsA('Bot') )
			BotConfig.AdjustSkill(Bot(Other),false);
	}
		
	if ( Other.bIsPlayer && (Killer != None) && Killer.bIsPlayer && (Killer != Other) 
		&& (!bTeamGame || (Other.PlayerReplicationInfo.Team != Killer.PlayerReplicationInfo.Team)) )
	{
		Killer.Spree++;
		if ( Killer.Spree > 4 )
			NotifySpree(Killer, Killer.Spree);
	} 
/*
	bAutoTaunt = ((TournamentPlayer(Killer) != None) && TournamentPlayer(Killer).bAutoTaunt);
	if ( ((Bot(Killer) != None) || bAutoTaunt)
		&& (Killer != Other) && (DamageType != 'gibbed') && (Killer.Health > 0)
		&& (Level.TimeSeconds - LastTauntTime > 3) )
	{
		LastTauntTime = Level.TimeSeconds;
		NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
		for ( i=0; i<4; i++ )
		{
			if ( NextTaunt == LastTaunt[i] )
				NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
			if ( i > 0 )
				LastTaunt[i-1] = LastTaunt[i];
		}	
		LastTaunt[3] = NextTaunt;
 		killer.SendGlobalMessage(None, 'AUTOTAUNT', NextTaunt, 5);
	}
*/
	if ( bRatedGame )
		RateVs(Other, Killer);
}


function bool ChangeTeam(Pawn Other, int NewTeam)
{
	local int i, Smallest, DesiredTeam;
	local pawn APlayer, P;
	local teaminfo SmallestTeam;

	if ( bRatedGame && (Other.PlayerReplicationInfo.Team != 255) )
		return false;
	if ( Other.IsA('Spectator') )
	{
		Other.PlayerReplicationInfo.Team = 255;
		if (LocalLog != None)
			LocalLog.LogTeamChange(Other);
		if (WorldLog != None)
			WorldLog.LogTeamChange(Other);
		return true;
	}

	if ( Other.IsA('Bot') )
	{
		Other.PlayerReplicationInfo.Team = 1;

		return true;
	}
	// find smallest team
	Smallest = 0;
	for( i=1; i<MaxTeams; i++ )
		if ( Teams[Smallest].Size > Teams[i].Size )
			Smallest = i;

	if ( (NewTeam == 255) || (NewTeam >= MaxTeams) )
		NewTeam = Smallest;
/*
	if ( bPlayersBalanceTeams && (Level.NetMode != NM_Standalone) )
	{
		if ( Teams[NewTeam].Size > Teams[Smallest].Size )
			NewTeam = Smallest;
		if ( NumBots == 1 )
		{
			// join bot's team if sizes are equal, because he will leave
			for ( P=Level.PawnList; P!=None; P=P.NextPawn )
				if ( P.IsA('Bot') )
					break;
			
			if ( (P != None) && (P.PlayerReplicationInfo != None) && (P.PlayerReplicationInfo.Team != 255)
				&& (Teams[P.PlayerReplicationInfo.Team].Size == Teams[Smallest].Size) )
				NewTeam = P.PlayerReplicationInfo.Team;
		}
	}
*/
	if ( (Other.PlayerReplicationInfo.Team == NewTeam) && bNoTeamChanges )
		return false;

	if ( Other.IsA('TournamentPlayer') )
		TournamentPlayer(Other).StartSpot = None;

	if ( Other.PlayerReplicationInfo.Team != 255 )
	{
		ClearOrders(Other);
		Teams[Other.PlayerReplicationInfo.Team].Size--;
	}

	if ( Teams[NewTeam].Size < MaxTeamSize )
	{
		AddToTeam(NewTeam, Other);
		return true;
	}

	if ( Other.PlayerReplicationInfo.Team == 255 )
	{
		AddToTeam(Smallest, Other);
		return true;
	}

	return false;
}



//funtion rewritten to spawn players at team 0 (Red) and bots to team 1 (Blue)
function AddToTeam( int num, Pawn Other )
{
	local teaminfo aTeam;
	local Pawn P;
	local bool bSuccess;
	local string SkinName, FaceName;

	if ( Other == None )
	{
		log("Added none to team!!!");
		return;
	}

	
	if ( Other.IsA('PlayerPawn') )
	{
		Other.PlayerReplicationInfo.TeamID = 0;
		PlayerPawn(Other).ClientChangeTeam(0);
	}
	else
		Other.PlayerReplicationInfo.TeamID = 1;
/*
	while ( !bSuccess )
	{
		bSuccess = true;
		for ( P=Level.PawnList; P!=None; P=P.nextPawn )
            if ( P.bIsPlayer && (P != Other) && (P.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team) && (P.PlayerReplicationInfo.TeamId == Other.PlayerReplicationInfo.TeamId) )
				bSuccess = false;
		if ( !bSuccess )
			Other.PlayerReplicationInfo.TeamID++;
	}
*/

	Other.static.GetMultiSkin(Other, SkinName, FaceName);
	Other.static.SetMultiSkin(Other, SkinName, FaceName, num);

	ReBalance();

}

function bool CanSpectate( pawn Viewer, actor ViewTarget )
{
	if ( ViewTarget.bIsPawn && (Pawn(ViewTarget).PlayerReplicationInfo != None)
		&& Pawn(ViewTarget).PlayerReplicationInfo.bIsSpectator )
		return false;
	if ( Viewer.PlayerReplicationInfo.bIsSpectator && (Viewer.PlayerReplicationInfo.Team == 255) )
		return true;
	return ( (Pawn(ViewTarget) != None) && Pawn(ViewTarget).bIsPlayer 
		&& (Pawn(ViewTarget).PlayerReplicationInfo.Team == Viewer.PlayerReplicationInfo.Team) );
}

function TeamInfo GetTeam(int TeamNum )
{
	if ( TeamNum < ArrayCount(Teams) )
		return Teams[TeamNum];
	else return None;
}

function bool IsOnTeam(Pawn Other, int TeamNum)
{
	if ( Other.PlayerReplicationInfo.Team == TeamNum )
		return true;

	return false;
}

//modified to only spawn Bots into team 1 (Blue)
function bool AddBot()
{
	local bot NewBot;
	local NavigationPoint StartSpot, OldStartSpot;
	local int DesiredTeam, i, MinSize;

	NewBot = SpawnBot(StartSpot);
	if ( NewBot == None )
	{
		log("Failed to spawn bot");
		return false;
	}

	NewBot.PlayerReplicationInfo.Team = 1;

	OldStartSpot = StartSpot;
	StartSpot = FindPlayerStart(NewBot,255);

	if ( StartSpot != None )
		{
		NewBot.SetLocation(StartSpot.Location);
		NewBot.SetRotation(StartSpot.Rotation);
		NewBot.ViewRotation = StartSpot.Rotation;
		NewBot.SetRotation(NewBot.Rotation);
		StartSpot.PlayTeleportEffect( NewBot, true );
		}

	StartSpot.PlayTeleportEffect(NewBot, true);

	SetBotOrders(NewBot);

	return true;
}

/*
function SetBotOrders(Bot NewBot)
{
	local Pawn P, L;
	local int num, total;

	// only follow players, if there are any
	if ( (NumSupportingPlayer == 0)
		 || (NumSupportingPlayer < Teams[NewBot.PlayerReplicationInfo.Team].Size/2 - 1) ) 
	{
		For ( P=Level.PawnList; P!=None; P= P.NextPawn )
			if ( P.IsA('PlayerPawn') && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team)
				&& !P.IsA('Spectator') )
		{
			num++;
			if ( (L == None) || (FRand() < 1.0/float(num)) )
				L = P;
		}

		if ( L != None )
		{
			NumSupportingPlayer++;
			NewBot.SetOrders('Follow',L,true);
			return;
		}
	}
	num = 0;
	For ( P=Level.PawnList; P!=None; P= P.NextPawn )
		if ( P.bIsPlayer && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team) )
		{
			total++;
			if ( (P != NewBot) && P.IsA('Bot') && (Bot(P).Orders == 'FreeLance') )
			{
				num++;
				if ( (L == None) || (FRand() < 1/float(num)) )
					L = P;
			}
		}
				
	if ( (L != None) && (FRand() < float(num)/float(total)) )
	{
		NewBot.SetOrders('Follow',L,true);
		return;
	}
	NewBot.SetOrders('Freelance', None,true);
}
*/				 

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	if ( (Other.bIsPlayer && (aBot.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team))
		|| (Other.IsA('TeamCannon') 
			&& (StationaryPawn(Other).SameTeamAs(aBot.PlayerReplicationInfo.Team))) ) 
		return 3;
	else 
		return Super.AssessBotAttitude(aBot, Other);
}

function Actor SetDefenseFor(Bot aBot)
{
	return None;
}

function bool FindSpecialAttractionFor(Bot aBot)
{
	return false;
}

function SetAttractionStateFor(Bot aBot)
{
	if ( aBot.Enemy != None )
	{
		if ( !aBot.IsInState('FallBack') )
		{
			aBot.bNoClearSpecial = true;
			aBot.TweenToRunning(0.1);
			aBot.GotoState('FallBack','SpecialNavig');
		}
	}
	else if ( !aBot.IsInState('Roaming') )
	{
		aBot.bNoClearSpecial = true;
		aBot.TweenToRunning(0.1);
		aBot.GotoState('Roaming', 'SpecialNavig');
	}
}

/*
function PickAmbushSpotFor(Bot aBot)
{
	local NavigationPoint N;

	for ( N=Level.NavigationPointList; N!=None; N=N.NextNavigationPoint )
		if ( N.IsA('Ambushpoint') && !N.taken )
		{
			if ( aBot.Orders == 'Defend' )
			{
				if ( N.IsA('DefensePoint') && (DefensePoint(N).team == aBot.PlayerReplicationInfo.team) )
				{
					if ( (DefensePoint(aBot.Ambushspot) == None)
						|| (DefensePoint(N).priority > DefensePoint(aBot.Ambushspot).priority) )
						aBot.Ambushspot = Ambushpoint(N);
					else if ( (DefensePoint(N).priority == DefensePoint(aBot.Ambushspot).priority)
						&& (FRand() < 0.4) ) 
						aBot.Ambushspot = Ambushpoint(N);
				}		
				else if ( (DefensePoint(aBot.AmbushSpot) == None)
						&& (VSize(N.Location - aBot.OrderObject.Location) < 1500)
						&& FastTrace(aBot.OrderObject.Location, N.Location)
						&& ((aBot.Ambushspot == None) || (FRand() < 0.5)) )
							aBot.Ambushspot = Ambushpoint(N);
			}
			else if ( (aBot.AmbushSpot == None)
				|| (VSize(aBot.Location - aBot.Ambushspot.Location)
					 > VSize(aBot.Location - N.Location)) )
				aBot.Ambushspot = Ambushpoint(N);
		}
}
*/

function byte PriorityObjective(Bot aBot)
{
	return 0;
}


/*
function bool SuccessfulGame()
{
}
*/

/*
function ClearOrders(Pawn Leaving)
{
	local Pawn P;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('Bot') && (Bot(P).OrderObject == Leaving) )
			Bot(P).SetOrders('Freelance', None);
}
*/

function bool WaitForPoint(bot aBot)
{
	return false;
}

function bool SendBotToGoal(Bot aBot)
{
	return false;
}

function bool HandleTieUp(Bot Bumper, Bot Bumpee)
{
	return false;
}

//------------------------------------------------------------------------------
// Game Querying.

function string GetRules()
{
	local string ResultSet;
	ResultSet = Super(TournamentGameInfo).GetRules();

	ResultSet = ResultSet$"\\timelimit\\"$TimeLimit;
	ResultSet = ResultSet$"\\goalteamscore\\"$int(GoalTeamScore);
	Resultset = ResultSet$"\\minplayers\\"$MinPlayers;
	Resultset = ResultSet$"\\changelevels\\"$bChangeLevels;
	ResultSet = ResultSet$"\\maxteams\\"$MaxTeams;
	ResultSet = ResultSet$"\\balanceteams\\"$bBalanceTeams;
	ResultSet = ResultSet$"\\playersbalanceteams\\"$bPlayersBalanceTeams;
	ResultSet = ResultSet$"\\friendlyfire\\"$int(FriendlyFireScale*100)$"%";
	Resultset = ResultSet$"\\tournament\\"$bTournament;
	if(bMegaSpeed)
		Resultset = ResultSet$"\\gamestyle\\Turbo";
	else
	if(bHardcoreMode)
		Resultset = ResultSet$"\\gamestyle\\Hardcore";
	else
		Resultset = ResultSet$"\\gamestyle\\Classic";

	if(MinPlayers > 0)
		Resultset = ResultSet$"\\botskill\\"$class'ChallengeBotInfo'.default.Skills[Difficulty];

	return ResultSet;
}

//The timer handles these functions:
// - Transfer all players stats to the DB each second
// - +1 to Lawgiver ammo if < 50
// - Access the DB and transfer stats to Players
// - int TimerEvent swithes what to do each time function Timer is called (rate is defined in function PostBeginPlay)
// - Transferes the teampStats to Replication Info
simulated function Timer()
{
local int i,ii;
local PlayerPawn P;

	if ( TimerEvent == 0)
		{
		AccessDB();
		}
	else if ( TimerEvent == 1)
		{
		TransferTempToGRI();
		}
	else if ( TimerEvent == 2)
		{
		foreach AllActors(class'PlayerPawn', P)
			{
			for (i=0;i<16;i++)
				{
				if (P.PlayerReplicationInfo.PlayerName == TPlayers[i] || TPlayers[i] == "")
					{
					TPlayers[i] = P.PlayerReplicationInfo.PlayerName;
					TScore[i] = P.PlayerReplicationInfo.Score;
					for (ii=0;ii<10000;ii++)
						{
						if ( TPlayers[i] == Players[ii] )
							{
							Players[ii] = TPlayers[i];
							Score[ii] = TScore[i];
							Level[ii] = TLevel[i];
							Weapons[ii] = TWeapons[i];
							RegainHealth[ii] = TRegainHealth[i];
							RegainAmmo[ii] = TRegainAmmo[i];
							RReduceDamage[ii] = TReduceDamage[i];
							AddToDamage[ii] = TAddToDamage[i];
							AddFireDamage[ii] = TAddFireDamage[i];
							AddLightningDamage[ii] = TAddLightningDamage[i];
							AddPoisonDamage[ii] = TAddPoisonDamage[i];
							AddColdDamage[ii] = TAddColdDamage[i];
							LastVisit[ii] = TLastVisit[i];
							ii = 20000;
							}
						}
					i=50;
					}
				}
			if (P.Weapon != None)
				{
				if (P.Weapon.ItemName == "Lawgiver" || P.Weapon.ItemName == "2x Lawgiver")
					{
					if ( P.Weapon.AmmoType.AmmoAmount < 50 )
						{
						P.Weapon.AmmoType.AmmoAmount++;
						}
					}
				}
			}
		}

	TimerEvent++;
	if ( TimerEvent >= 3)
		{
		TimerEvent = 0;
		}
}

function UpdateDB()
{
local PlayerPawn P;
local int i,ii;

	if (!Init2)
		{
		foreach AllActors(class'PlayerPawn', P)
			{
			for (i=0;i<10000;i++)
				{
				}
			}
		Init2 = True;
		SaveConfig();
		}
}


function bool HandleEndGame()
{
	UpdateDB();
}

defaultproperties
{
     bScoreTeamKills=True
     bBalanceTeams=False
     bPlayersBalanceTeams=False
     MaxTeams=2
     MaxAllowedTeams=2
     GoalTeamScore=0.000000
     MaxTeamSize=16
     StartUpTeamMessage=""
     TeamChangeMessage=""
     TeamColor(0)=""
     TeamColor(1)="Evil"
     TeamColor(2)="Green"
     TeamColor(3)="Gold"
     TEAM_Blue=1
     TEAM_Green=2
     TEAM_Gold=3
     CurrentOrders(0)=Defend
     CurrentOrders(1)=Defend
     CurrentOrders(2)=Defend
     CurrentOrders(3)=Defend
     StartupTeamTralier=""
     StartUpMessage="Destroy your oponents!"
     MaxCommanders=2
     bCanChangeSkin=False
     bTeamGame=True
     ScoreBoardType=Class'rpg_SB'
     RulesMenuType="UTMenu.UTTeamRSClient"
     SettingsMenuType="UTMenu.UTTeamSSClient"
     HUDType=Class'rpg_HUD'
     MapPrefix="RPG"
     BeaconName="RPG"
     GameName="TheDanes RPG game"
     MapListType=Class'rpg_Maplist'
     MutatorClass=Class'Mutator_Base'
     bCoopWeaponMode=True
     GameReplicationInfoClass=Class'rpg_GRI'
}
